-- Note: Please use the in-game editor to change your toasty.

-- If you are adding a toasty that isn't in moonlight, you will need to edit
-- the ToastyCommands table below.
local toasty;

if GetUserPref("Toasty") == nil then
	toasty = "Forden";
	SetUserPref("Toasty",toasty);
else
	toasty = GetUserPref("Toasty");
end;

-- xxx: come up with better toasty commands, since most of them suck!

-- these are the generic commands, to be replaced later.
local init = cmd(horizalign,left;vertalign,bottom;x,SCREEN_WIDTH;y,SCREEN_HEIGHT);
local on = cmd(decelerate,0.3;x,SCREEN_WIDTH*0.73125;sleep,1.0;accelerate,0.3;x,SCREEN_WIDTH);

local ToastyCommands = {

	-- ok
	Forden = {
		InitCmd = init,
		OnCmd = cmd(decelerate,0.3;x,SCREEN_WIDTH*0.85;sleep,1.0;accelerate,0.3;x,SCREEN_WIDTH)
	},

	-- ok
	Nima = {
		InitCmd = init,
		OnCmd = on
	},

	-- ok
	Snorlax = {
		InitCmd = cmd(x,SCREEN_CENTER_X;y,SCREEN_TOP-512;zoom,2;draworder,9999),
		OnCmd = cmd(sleep,2.5;linear,1.25;addy,2048)
	},

	-- done
	BangBang = {
		InitCmd = cmd(horizalign,right;vertalign,bottom;x,SCREEN_WIDTH;y,SCREEN_HEIGHT*1.5),
		OnCmd = cmd(accelerate,0.15;y,SCREEN_HEIGHT;sleep,1.25;decelerate,0.3;y,SCREEN_HEIGHT*1.5)
	},

	-- ok
	Charmy = {
		InitCmd = init,
		OnCmd = on
	},

	-- not enabled yet
	Foy = {
		InitCmd = init,
		OnCmd = on
	},

	-- not added yet
	CD = {
		InitCmd = init,
		OnCmd = on
	},
--[[ end toasties packaged with moonlight  ]]

-- add your toasties here until I get a better system in place

--[[ no need to edit below this line ]]
};

local t = Def.ActorFrame{
	LoadActor( THEME:GetPathG("","_toasty/"..toasty) ) ..{
		InitCommand=ToastyCommands[toasty].InitCmd;
		OnCommand=ToastyCommands[toasty].OnCmd;
	};
	LoadActor( THEME:GetPathS("_toasty",toasty) ) ..{
		StartTransitioningCommand=cmd(play);
	};
};

return t;